/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.init;

import net.adventurez.entity.AmethystGolemEntity;
import net.adventurez.entity.BlackstoneGolemEntity;
import net.adventurez.entity.BlazeGuardianEntity;
import net.adventurez.entity.BrownFungusEntity;
import net.adventurez.entity.DeerEntity;
import net.adventurez.entity.DesertRhinoEntity;
import net.adventurez.entity.DragonEntity;
import net.adventurez.entity.EnderWhaleEntity;
import net.adventurez.entity.EnderwarthogEntity;
import net.adventurez.entity.IguanaEntity;
import net.adventurez.entity.MammothEntity;
import net.adventurez.entity.MiniBlackstoneGolemEntity;
import net.adventurez.entity.NecromancerEntity;
import net.adventurez.entity.NightmareEntity;
import net.adventurez.entity.OrcEntity;
import net.adventurez.entity.PiglinBeastEntity;
import net.adventurez.entity.RedFungusEntity;
import net.adventurez.entity.ShamanEntity;
import net.adventurez.entity.SkeletonVanguardEntity;
import net.adventurez.entity.SoulReaperEntity;
import net.adventurez.entity.SummonerEntity;
import net.adventurez.entity.TheEyeEntity;
import net.adventurez.entity.VoidFragmentEntity;
import net.adventurez.entity.VoidShadeEntity;
import net.adventurez.entity.VoidShadowEntity;
import net.adventurez.entity.WitherPuppetEntity;
import net.adventurez.entity.nonliving.AmethystShardEntity;
import net.adventurez.entity.nonliving.BlazeGuardianShieldEntity;
import net.adventurez.entity.nonliving.FireBreathEntity;
import net.adventurez.entity.nonliving.GildedBlackstoneShardEntity;
import net.adventurez.entity.nonliving.ThrownRockEntity;
import net.adventurez.entity.nonliving.TinyEyeEntity;
import net.adventurez.entity.nonliving.VoidBulletEntity;
import net.adventurez.entity.nonliving.VoidCloudEntity;
import net.adventurez.init.ItemInit;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;

public class EntityInit {
    public static final EntityType<BlackstoneGolemEntity> BLACKSTONE_GOLEM = EntityInit.register("blackstone_golem", 2956072, 1445648, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MONSTER, BlackstoneGolemEntity::new).fireImmune().dimensions(EntityDimensions.m_20398_((float)3.36f, (float)4.44f)).build());
    public static final EntityType<MiniBlackstoneGolemEntity> MINI_BLACKSTONE_GOLEM = EntityInit.register("mini_blackstone_golem", 4077380, 4400440, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MONSTER, MiniBlackstoneGolemEntity::new).fireImmune().dimensions(EntityDimensions.m_20398_((float)1.2f, (float)1.2f)).build());
    public static final EntityType<PiglinBeastEntity> PIGLIN_BEAST = EntityInit.register("piglin_beast", 5121815, 14192743, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MONSTER, PiglinBeastEntity::new).fireImmune().dimensions(EntityDimensions.m_20398_((float)1.55f, (float)3.35f)).build());
    public static final EntityType<SoulReaperEntity> SOUL_REAPER = EntityInit.register("soul_reaper", 0x151515, 0x515353, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MONSTER, SoulReaperEntity::new).fireImmune().dimensions(EntityDimensions.m_20398_((float)0.7f, (float)2.4f)).build());
    public static final EntityType<NecromancerEntity> NECROMANCER = EntityInit.register("necromancer", 0x161616, 15514145, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MONSTER, NecromancerEntity::new).fireImmune().dimensions(EntityDimensions.m_20398_((float)0.9f, (float)2.4f)).build());
    public static final EntityType<WitherPuppetEntity> WITHER_PUPPET = EntityInit.register("wither_puppet", 0x131313, 0x2F2F2F, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MONSTER, WitherPuppetEntity::new).fireImmune().dimensions(EntityDimensions.m_20398_((float)0.7f, (float)1.32f)).build());
    public static final EntityType<SkeletonVanguardEntity> SKELETON_VANGUARD = EntityInit.register("skeleton_vanguard", 0xBCBCBC, 11766305, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MONSTER, SkeletonVanguardEntity::new).dimensions(EntityDimensions.m_20398_((float)0.7f, (float)2.1f)).build());
    public static final EntityType<SummonerEntity> SUMMONER = EntityInit.register("summoner", 0xBCBCBC, 5847892, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MONSTER, SummonerEntity::new).dimensions(EntityDimensions.m_20398_((float)0.9f, (float)2.65f)).build());
    public static final EntityType<BlazeGuardianEntity> BLAZE_GUARDIAN = EntityInit.register("blaze_guardian", 16766248, 9122817, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MONSTER, BlazeGuardianEntity::new).fireImmune().dimensions(EntityDimensions.m_20398_((float)0.8f, (float)2.25f)).build());
    public static final EntityType<TheEyeEntity> THE_EYE = EntityInit.register("the_eye", 1984565, 1059889, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MONSTER, TheEyeEntity::new).fireImmune().dimensions(EntityDimensions.m_20398_((float)2.8f, (float)3.5f)).build());
    public static final EntityType<VoidShadowEntity> VOID_SHADOW = EntityInit.register("void_shadow", 1441901, 393244, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MONSTER, VoidShadowEntity::new).fireImmune().dimensions(EntityDimensions.m_20398_((float)10.2f, (float)15.3f)).build());
    public static final EntityType<OrcEntity> ORC = EntityInit.register("orc", 2255437, 3512689, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MONSTER, OrcEntity::new).dimensions(EntityDimensions.m_20395_((float)1.35f, (float)2.2f)).build());
    public static final EntityType<VoidShadeEntity> VOID_SHADE = EntityInit.register("void_shade", 1179727, 2956161, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MONSTER, VoidShadeEntity::new).dimensions(EntityDimensions.m_20398_((float)1.0f, (float)2.1f)).build());
    public static final EntityType<AmethystGolemEntity> AMETHYST_GOLEM = EntityInit.register("amethyst_golem", 0x525252, 9267916, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MONSTER, AmethystGolemEntity::new).dimensions(EntityDimensions.m_20398_((float)1.8f, (float)2.2f)).build());
    public static final EntityType<DesertRhinoEntity> DESERT_RHINO = EntityInit.register("desert_rhino", 7884087, 12031588, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MONSTER, DesertRhinoEntity::new).dimensions(EntityDimensions.m_20398_((float)2.3f, (float)2.35f)).build());
    public static final EntityType<ShamanEntity> SHAMAN = EntityInit.register("shaman", 210734, 8739394, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MONSTER, ShamanEntity::new).dimensions(EntityDimensions.m_20398_((float)0.9f, (float)2.01f)).build());
    public static final EntityType<EnderwarthogEntity> ENDERWARTHOG = EntityInit.register("enderwarthog", 2828080, 6553725, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MONSTER, EnderwarthogEntity::new).dimensions(EntityDimensions.m_20398_((float)2.3f, (float)2.15f)).build());
    public static final EntityType<RedFungusEntity> RED_FUNGUS = EntityInit.register("red_fungus", 13084791, 13183785, FabricEntityTypeBuilder.create((MobCategory)MobCategory.CREATURE, RedFungusEntity::new).dimensions(EntityDimensions.m_20398_((float)1.05f, (float)1.4f)).build());
    public static final EntityType<BrownFungusEntity> BROWN_FUNGUS = EntityInit.register("brown_fungus", 13084791, 9925201, FabricEntityTypeBuilder.create((MobCategory)MobCategory.CREATURE, BrownFungusEntity::new).dimensions(EntityDimensions.m_20398_((float)1.35f, (float)1.8f)).build());
    public static final EntityType<NightmareEntity> NIGHTMARE = EntityInit.register("nightmare", 0x151515, 3012863, FabricEntityTypeBuilder.create((MobCategory)MobCategory.CREATURE, NightmareEntity::new).fireImmune().dimensions(EntityDimensions.m_20398_((float)1.4f, (float)1.6f)).build());
    public static final EntityType<DragonEntity> DRAGON = EntityInit.register("dragon", 0x1C1C1C, 14711290, FabricEntityTypeBuilder.create((MobCategory)MobCategory.CREATURE, DragonEntity::new).dimensions(EntityDimensions.m_20395_((float)4.8f, (float)3.3f)).fireImmune().build());
    public static final EntityType<MammothEntity> MAMMOTH = EntityInit.register("mammoth", 4732462, 6376763, FabricEntityTypeBuilder.create((MobCategory)MobCategory.CREATURE, MammothEntity::new).dimensions(EntityDimensions.m_20395_((float)2.8f, (float)3.5f)).build());
    public static final EntityType<EnderWhaleEntity> ENDER_WHALE = EntityInit.register("ender_whale", 1711667, 6179950, FabricEntityTypeBuilder.create((MobCategory)MobCategory.CREATURE, EnderWhaleEntity::new).dimensions(EntityDimensions.m_20398_((float)4.0f, (float)2.5f)).build());
    public static final EntityType<IguanaEntity> IGUANA = EntityInit.register("iguana", 11485475, 8988193, FabricEntityTypeBuilder.create((MobCategory)MobCategory.CREATURE, IguanaEntity::new).dimensions(EntityDimensions.m_20395_((float)1.5f, (float)0.5f)).build());
    public static final EntityType<DeerEntity> DEER = EntityInit.register("deer", 5780491, 9725748, FabricEntityTypeBuilder.create((MobCategory)MobCategory.CREATURE, DeerEntity::new).dimensions(EntityDimensions.m_20395_((float)1.4f, (float)1.8f)).build());
    public static final EntityType<ThrownRockEntity> THROWN_ROCK = EntityInit.register("thrown_rock", 0, 0, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MISC, ThrownRockEntity::new).dimensions(EntityDimensions.m_20398_((float)1.5f, (float)1.5f)).build());
    public static final EntityType<GildedBlackstoneShardEntity> GILDED_BLACKSTONE_SHARD = EntityInit.register("gilded_blackstone_shard", 0, 0, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MISC, GildedBlackstoneShardEntity::new).dimensions(EntityDimensions.m_20398_((float)0.4f, (float)0.7f)).build());
    public static final EntityType<TinyEyeEntity> TINY_EYE = EntityInit.register("tiny_eye", 0, 0, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MISC, TinyEyeEntity::new).dimensions(EntityDimensions.m_20398_((float)0.4f, (float)0.4f)).build());
    public static final EntityType<VoidBulletEntity> VOID_BULLET = EntityInit.register("void_bullet", 0, 0, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MISC, VoidBulletEntity::new).dimensions(EntityDimensions.m_20398_((float)0.5f, (float)0.5f)).build());
    public static final EntityType<FireBreathEntity> FIRE_BREATH = EntityInit.register("fire_breath", 0, 0, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MISC, FireBreathEntity::new).dimensions(EntityDimensions.m_20398_((float)0.3f, (float)0.3f)).build());
    public static final EntityType<BlazeGuardianShieldEntity> BLAZE_GUARDIAN_SHIELD = EntityInit.register("blaze_guardian_shield", 0, 0, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MISC, BlazeGuardianShieldEntity::new).fireImmune().dimensions(EntityDimensions.m_20398_((float)0.65f, (float)1.6f)).build());
    public static final EntityType<AmethystShardEntity> AMETHYST_SHARD = EntityInit.register("amethyst_shard", 0, 0, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MISC, AmethystShardEntity::new).dimensions(EntityDimensions.m_20398_((float)0.6f, (float)0.8f)).build());
    public static final EntityType<VoidCloudEntity> VOID_CLOUD = EntityInit.register("void_cloud", 0, 0, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MISC, VoidCloudEntity::new).dimensions(EntityDimensions.m_20395_((float)6.0f, (float)0.5f)).fireImmune().build());
    public static final EntityType<VoidFragmentEntity> VOID_FRAGMENT = EntityInit.register("void_fragment", 1376335, 3670138, FabricEntityTypeBuilder.create((MobCategory)MobCategory.MONSTER, VoidFragmentEntity::new).dimensions(EntityDimensions.m_20395_((float)1.0f, (float)1.0f)).build());
    public static final ResourceKey<DamageType> AMETHYST_SHARD_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("adventurez", "amethyst_shard"));
    public static final ResourceKey<DamageType> VOID_BULLET_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("adventurez", "void_bullet"));
    public static final ResourceKey<DamageType> FIRE_BREATH_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("adventurez", "fire_breath"));
    public static final ResourceKey<DamageType> TINY_EYE_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("adventurez", "tiny_eye"));
    public static final ResourceKey<DamageType> ROCK_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("adventurez", "rock"));

    private static <T extends Entity> EntityType<T> register(String id, int primaryColor, int secondaryColor, EntityType<T> entityType) {
        if (primaryColor != 0) {
            Item item = (Item)Registry.m_122965_((Registry)BuiltInRegistries.f_257033_, (ResourceLocation)new ResourceLocation("adventurez", "spawn_" + id), (Object)new SpawnEggItem(entityType, primaryColor, secondaryColor, new Item.Properties()));
            ItemGroupEvents.modifyEntriesEvent(ItemInit.ADVENTUREZ_ITEM_GROUP).register(entries -> entries.m_246326_((ItemLike)item));
        }
        return (EntityType)Registry.m_122965_((Registry)BuiltInRegistries.f_256780_, (ResourceLocation)new ResourceLocation("adventurez", id), entityType);
    }

    public static void init() {
        FabricDefaultAttributeRegistry.register(BLACKSTONE_GOLEM, (AttributeSupplier.Builder)BlackstoneGolemEntity.createStoneGolemAttributes());
        FabricDefaultAttributeRegistry.register(MINI_BLACKSTONE_GOLEM, (AttributeSupplier.Builder)MiniBlackstoneGolemEntity.createSmallStoneGolemAttributes());
        FabricDefaultAttributeRegistry.register(PIGLIN_BEAST, (AttributeSupplier.Builder)PiglinBeastEntity.createPiglinBeastAttributes());
        FabricDefaultAttributeRegistry.register(NIGHTMARE, (AttributeSupplier.Builder)NightmareEntity.createNightmareAttributes());
        FabricDefaultAttributeRegistry.register(SOUL_REAPER, (AttributeSupplier.Builder)SoulReaperEntity.createSoulReaperAttributes());
        FabricDefaultAttributeRegistry.register(NECROMANCER, (AttributeSupplier.Builder)NecromancerEntity.createNecromancerAttributes());
        FabricDefaultAttributeRegistry.register(WITHER_PUPPET, (AttributeSupplier.Builder)WitherPuppetEntity.createWitherPuppetAttributes());
        FabricDefaultAttributeRegistry.register(SKELETON_VANGUARD, (AttributeSupplier.Builder)SkeletonVanguardEntity.createSkeletonVanguardAttributes());
        FabricDefaultAttributeRegistry.register(SUMMONER, (AttributeSupplier.Builder)SummonerEntity.createSummonerAttributes());
        FabricDefaultAttributeRegistry.register(BLAZE_GUARDIAN, (AttributeSupplier.Builder)BlazeGuardianEntity.createBlazeGuardianAttributes());
        FabricDefaultAttributeRegistry.register(THE_EYE, (AttributeSupplier.Builder)TheEyeEntity.createTheEntityAttributes());
        FabricDefaultAttributeRegistry.register(VOID_SHADOW, (AttributeSupplier.Builder)VoidShadowEntity.createVoidShadowAttributes());
        FabricDefaultAttributeRegistry.register(RED_FUNGUS, (AttributeSupplier.Builder)RedFungusEntity.createRedFungusAttributes());
        FabricDefaultAttributeRegistry.register(BROWN_FUNGUS, (AttributeSupplier.Builder)BrownFungusEntity.createBrownFungusAttributes());
        FabricDefaultAttributeRegistry.register(ORC, (AttributeSupplier.Builder)OrcEntity.createOrkAttributes());
        FabricDefaultAttributeRegistry.register(DRAGON, (AttributeSupplier.Builder)DragonEntity.createDragonAttributes());
        FabricDefaultAttributeRegistry.register(MAMMOTH, (AttributeSupplier.Builder)MammothEntity.createMammothAttributes());
        FabricDefaultAttributeRegistry.register(VOID_FRAGMENT, (AttributeSupplier.Builder)VoidFragmentEntity.createVoidFragmentAttributes());
        FabricDefaultAttributeRegistry.register(VOID_SHADE, (AttributeSupplier.Builder)VoidShadeEntity.createVoidShadeAttributes());
        FabricDefaultAttributeRegistry.register(ENDER_WHALE, (AttributeSupplier.Builder)EnderWhaleEntity.createEnderWhaleAttributes());
        FabricDefaultAttributeRegistry.register(IGUANA, (AttributeSupplier.Builder)IguanaEntity.createIguanaAttributes());
        FabricDefaultAttributeRegistry.register(AMETHYST_GOLEM, (AttributeSupplier.Builder)AmethystGolemEntity.createAmethystGolemAttributes());
        FabricDefaultAttributeRegistry.register(DESERT_RHINO, (AttributeSupplier.Builder)DesertRhinoEntity.createDesertRhinoAttributes());
        FabricDefaultAttributeRegistry.register(SHAMAN, (AttributeSupplier.Builder)ShamanEntity.createShamanAttributes());
        FabricDefaultAttributeRegistry.register(DEER, (AttributeSupplier.Builder)DeerEntity.createDeerAttributes());
        FabricDefaultAttributeRegistry.register(ENDERWARTHOG, (AttributeSupplier.Builder)EnderwarthogEntity.createEnderwarthogAttributes());
    }
}

